/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;

namespace Borland.Eco.Subscription
{

	public interface ISubscriber
	{
		bool Receive(System.Object sender, EventArgs e);  //  Return False if no longer alive
		bool IsAlive();
	}

	public sealed class SubscriberPair
	{
		private readonly ISubscriber valueChangeSubscriber;
		private readonly ISubscriber resubscribeSubscriber;

		public ISubscriber ValueChangeSubscriber
		{
			get { return valueChangeSubscriber; }
		}

		public ISubscriber ResubscribeSubscriber
		{
			get { return resubscribeSubscriber; }
		}

		public SubscriberPair(ISubscriber valueChangeSubscriber, ISubscriber resubscribeSubscriber)
		{
			this.valueChangeSubscriber = valueChangeSubscriber;
			this.resubscribeSubscriber = resubscribeSubscriber;
		}
	}
}
